<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Rotating Banner System                                                 # ||
|| # ---------------------------------------------------------------------- # ||
|| # (C) Copyright Y2K Software s.a.s. 2008 - All Rights Reserved.          # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| ########################################################################## ||
\*============================================================================*/

/**
 * @author Y2K Software
 * @copyright (C) Copyright Y2K Software 2008 - All Rights Reserved
 * @version 2.0.6
 * @link www.pagerobot.com
 */

error_reporting(E_ALL & ~ E_NOTICE);
define('CVS_REVISION', '$RCSfile$ - $Revision: 2 $');

$phrasegroups = array();
$specialtemplates = array();

require_once './global.php';

// #############################################################################
// ######################### START MAIN SCRIPT #################################
// #############################################################################

if(!can_administer('canadminmaintain'))
{
    print_cp_no_permission();
}

log_admin_action();

print_cp_header($vbphrase['rbs_rotating_banner_system']);
print_form_header('admin_rbs');
print_table_header($vbphrase['rbs_d_banner_list'], 4);
print_cells_row(array($vbphrase['rbs_id'], $vbphrase['rbs_short_name'], $vbphrase['rbs_short_impressions'], $vbphrase['rbs_short_clicks']), true);

$fmt = $id = '<a href="admin_rbs.php?rbs_id=%d">%s</a>';
$n = 0;
$SQL = "SELECT id, name, enabled, impressions, clicks, m_expired 
    FROM " . TABLE_PREFIX . "rbs_banners
    WHERE enabled=0 
    ORDER BY id";
$rss = $vbulletin->db->query_read($SQL);
while($rs = $vbulletin->db->fetch_array($rss))
{
    $id = sprintf($fmt, $rs['id'], vb_number_format($rs['id']));
    if(!$rs['name'])
    {
    	$rs['name'] = $vbphrase['None'];
    }
    if($rs['m_expired'])
    {
    	$rs['name'] = '*' . $rs['name'];
    }
    if($rs['enabled'])
    {
    	$rs['name'] = '<b>' . htmlspecialchars_uni($rs['name']) . '</b>';
    }
    else
    {
    	$rs['name'] = htmlspecialchars_uni($rs['name']);
    }
    
    $name = sprintf($fmt, $rs['id'], $rs['name']);
    $impressions = vb_number_format($rs['impressions']);
    $clicks = vb_number_format($rs['clicks']);
    print_cells_row(array($id, $name, $impressions, $clicks), false, '', -1);
    $n++;
}

if(!$n)
{
    print_description_row($vbphrase['none'], false, 4);
}

print_table_footer();
print_cp_footer();
?>